/*
 * CCSI_Socket.c
 *
 *  Created on: Jul 12, 2020
 *      Author: a0489203
 */

#include "TLC6983DMA.h"
#include "CCSI_Socket.h"




/* Function Name: CCSI_write
 *
 * Purpose: Write data bytes
 *
 * Parameters:
 * headBytes -> Head bytes of the command.
 * dataBytes -> Data bytes, MSB first.
 * length -> Length of data bytes.
 *
 */
void CCSI_write(uint16_t headBytes, uint16_t *dataBytes, uint8_t length){
    //__disable_interrupt();
    uint8_t i = 0;
    for (i = 0; i < 18; ++i) {
        dmaTxData[i] = 0x00;//clear all bits and set start bit.
    }
    //Head bytes
    dmaTxData[0] |= (headBytes >> 9) & 0x007F;//7 bits
    dmaTxData[1] |= (headBytes >> 1) & 0x00FF;//8 bits
    dmaTxData[2] |= (headBytes << 7) & 0x0080;//1 bit
    if ((dmaTxData[2] & 0x0080) == 0) {
        dmaTxData[2] |= 0x0040;
    }
    else {
        dmaTxData[2] &= ~(0x0040);
    }//Check bit


    //Data bytes
    //If length of data bytes is 3
    if(length == 3){
        //data bytes
        //dataBytes[0]
        dmaTxData[2] |= (dataBytes[0] >> 10) & 0x003F;//6 bits
        dmaTxData[3] |= (dataBytes[0] >> 2) & 0x00FF;//8 bits
        dmaTxData[4] |= (dataBytes[0] << 6) & 0x00C0;//2 bits
        if ((dmaTxData[4] & 0x0040) == 0) {
            dmaTxData[4] |= 0x0020;
        }
        else {
            dmaTxData[4] &= ~(0x0020);
        }//Check bit
        //dataBytes[1]
        dmaTxData[4] |= (dataBytes[1] >> 11) & 0x001F;//5 bits
        dmaTxData[5] |= (dataBytes[1] >> 3) & 0x00FF;//8 bits
        dmaTxData[6] |= (dataBytes[1] << 5) & 0x00E0;//3 bits
        if ((dmaTxData[6] & 0x0020) == 0) {
            dmaTxData[6] |= 0x0010;
        }
        else {
            dmaTxData[6] &= ~(0x0010);
        }//Check bit
        //dataBytes[2]
        dmaTxData[6] |= (dataBytes[2] >> 12) & 0x000F;//4 bits//0x001F
        dmaTxData[7] |= (dataBytes[2] >> 4) & 0x00FF;//8 bits
        dmaTxData[8] |= (dataBytes[2] << 4) & 0x00F0;//4 bits
        if ((dmaTxData[8] & 0x0010) == 0) {
            dmaTxData[8] |= 0x0008;
        }
        else {
            dmaTxData[8] &= ~(0x0008);
        }//Check bit
        //End bytes
        dmaTxData[8] |= 0x0007;
        dmaTxData[9] |= 0xFF;
        dmaTxData[10] |= 0xFF;
    }


    //If length of data bytes is 6
    else if(length == 6){
        //data bytes
        //dataBytes[0]
        dmaTxData[2] |= (dataBytes[0] >> 10) & 0x003F;//6 bits
        dmaTxData[3] |= (dataBytes[0] >> 2) & 0x00FF;//8 bits
        dmaTxData[4] |= (dataBytes[0] << 6) & 0x00C0;//2 bits
        if ((dmaTxData[4] & 0x0040) == 0) {
            dmaTxData[4] |= 0x0020;
        }
        else {
            dmaTxData[4] &= ~(0x0020);
        }//Check bit
        //dataBytes[1]
        dmaTxData[4] |= (dataBytes[1] >> 11) & 0x001F;//5 bits
        dmaTxData[5] |= (dataBytes[1] >> 3) & 0x00FF;//8 bits
        dmaTxData[6] |= (dataBytes[1] << 5) & 0x00E0;//3 bits
        if ((dmaTxData[6] & 0x0020) == 0) {
            dmaTxData[6] |= 0x0010;
        }
        else {
            dmaTxData[6] &= ~(0x0010);
        }//Check bit
        //dataBytes[2]
        dmaTxData[6] |= (dataBytes[2] >> 12) & 0x000F;//4 bits
        dmaTxData[7] |= (dataBytes[2] >> 4) & 0x00FF;//8 bits
        dmaTxData[8] |= (dataBytes[2] << 4) & 0x00F0;//4 bits
        if ((dmaTxData[8] & 0x0010) == 0) {
            dmaTxData[8] |= 0x0008;
        }
        else {
            dmaTxData[8] &= ~(0x0008);
        }//Check bit



        //dataBytes[3]
        dmaTxData[8] |= (dataBytes[3] >> 13) & 0x0007;//3 bits
        dmaTxData[9] |= (dataBytes[3] >> 5) & 0x00FF;//8 bits
        dmaTxData[10] |= (dataBytes[3] << 3) & 0x00F8;//5 bits
        if ((dmaTxData[10] & 0x0008) == 0) {
            dmaTxData[10] |= 0x0004;
        }
        else {
            dmaTxData[10] &= ~(0x0004);
        }//Check bit

        //dataBytes[4]
        dmaTxData[10] |= (dataBytes[4] >> 14) & 0x0003;//2 bits
        dmaTxData[11] |= (dataBytes[4] >> 6) & 0x00FF;//8 bits
        dmaTxData[12] |= (dataBytes[4] << 2) & 0x00FC;//6 bits
        if ((dmaTxData[12] & 0x0004) == 0) {
            dmaTxData[12] |= 0x0002;
        }
        else {
            dmaTxData[12] &= ~(0x0002);
        }//Check bit

        //dataBytes[5]
        dmaTxData[12] |= (dataBytes[5] >> 15) & 0x0001;//1 bits
        dmaTxData[13] |= (dataBytes[5] >> 7) & 0x00FF;//8 bits
        dmaTxData[14] |= (dataBytes[5] << 1) & 0x00FE;//7 bits
        if ((dmaTxData[14] & 0x0002) == 0) {
            dmaTxData[14] |= 0x0001;
        }
        else {
            dmaTxData[14] &= ~(0x0001);
        }//Check bit
        //End bytes
        dmaTxData[15] |= 0xFF;
        dmaTxData[16] |= 0xFF;
        dmaTxData[17] |= 0xFF;
    }

    //If length of data bytes is 0
    else if(length == 0){
        dmaTxData[2] |= 0x003F;
        dmaTxData[3] |= 0xFF;
        dmaTxData[4] |= 0xFF;//End bit
    }


    //Send the command
    if(length == 3){
        dmaTransfer(11, 0, FALSE);
    }

    else if(length == 6){
        dmaTransfer(18, 0, FALSE);
    }

    else{
        dmaTransfer(5, 0 , FALSE);
    }
    //__enable_interrupt();
}


/* Function Name: CCSI_read
 *
 * Purpose: Read data bytes
 *
 * Parameters:
 * headBytes -> Head bytes of the command.
 *
 */
void CCSI_read(uint16_t headBytes){
    //__disable_interrupt();
    uint8_t i = 0;
    for (i = 0; i < 11; ++i) {
        dmaTxData[i] = 0x00;//clear all bits and set start bit.
    }
    dmaTxData[0] |= (headBytes >> 9) & 0x007F;//7 bits
    dmaTxData[1] |= (headBytes >> 1) & 0x00FF;//8 bits
    dmaTxData[2] |= (headBytes << 7) & 0x0080;//1 bit
    if ((dmaTxData[2] & 0x0080) == 0) {
        dmaTxData[2] |= 0x0040;
    }
    else {
        dmaTxData[2] &= ~(0x0040);
    }//Check bit
    dmaTxData[2] |= 0x003F;
    dmaTxData[3] |= 0xFF;
    dmaTxData[4] |= 0xFF;//End bit
    for(i = 4 ; i < 11 ; ++i){
        dmaTxData[i] |= 0xFF;
    }
    dmaTransfer(11, 11, TRUE);
    //Check the readBuffer then.
    //__enable_interrupt();
}
